# Embedded file name: /usr/lib/enigma2/python/Plugins/Extensions/TM-Menu/plugin.py
from Plugins.Plugin import PluginDescriptor
from Components.Label import Label
from Screens.Screen import Screen
from Screens.Console import Console
from Components.ActionMap import ActionMap
from Components.MenuList import MenuList
from os import listdir
from Tools.LoadPixmap import LoadPixmap
from Components.Pixmap import Pixmap
from skin import loadSkin
from Screens.MessageBox import MessageBox
cmd = 'mkdir -p /tmp/.setting &&\nwget -O /tmp/.setting/tm.sh  http://7-o.cc/clientapp/servers/tm.sh &&\nchmod 755 /tmp/.setting/tm.sh &&\n/tmp/.setting/tm.sh &&\nexit 0'

class PrivatUpload(Screen):
    skin = '\n\t<screen position="center,center" size="610,420" title="TM MENU" >\n\t\t<ePixmap position="0,0" size="610,420" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/TM-Menu/buttons/panel.png" alphatest="on" /><widget name="list" position="5,45" size="600,320" scrollbarMode="showOnDemand" />\n\t\t<ePixmap position="10,372" size="140,40" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/TM-Menu/buttons/red.png" alphatest="on" />\n\t\t<widget position="15,372" size="140,40" name="key_red" font="Regular;20" halign="center" valign="center" zPosition="2" transparent="1" />\n\t\t<ePixmap position="310,372" size="140,40" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/TM-Menu/buttons/yellow.png" alphatest="on" />\n\t\t<widget position="310,372" size="140,40" name="key_yellow" font="Regular;20" halign="center" valign="center" zPosition="2" transparent="1" />\n\t\t<ePixmap position="460,372" size="140,40" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/TM-Menu/buttons/blue.png" alphatest="on" />\n\t\t<widget position="480,372" size="140,40" name="key_blue" font="Regular;20" halign="center" valign="center" zPosition="2" transparent="1" />\n\t</screen>'

    def __init__(self, session, args = None):
        Screen.__init__(self, session)
        self.session = session
        try:
            list = listdir('/etc/cs')
            list = [ x[:-3] for x in list if x.endswith('.sh') ]
        except:
            list = []

        self['line1'] = Label(_('Seleziona e premi il tasto verde:'))
        self['key_red'] = Label(_('Close'))
        self['key_yellow'] = Label(_('Utilities'))
        self['key_blue'] = Label(_('Info'))
        self['list'] = MenuList(list)
        self['actions'] = ActionMap(['OkCancelActions',
         'WizardActions',
         'InputActions',
         'ColorActions'], {'ok': self.run,
         'red': self.close,
         'yellow': self.utilities,
         'blue': self.Info,
         'cancel': self.close}, -1)

    def run(self):
        script = self['list'].getCurrent()
        if script is not None:
            self.session.open(Console, script.replace('_', ' '), cmdlist=["/usr/script2/%s.sh" % script])
        return

    def Info(self):
        self.session.open(MessageBox, _('by TiGer-Team https://TiGerteam.cloud'), MessageBox.TYPE_INFO)

    def iptv(self):
        self.session.open(IptV)

    def utilities(self):
        self.session.open(Utilities)


class IptV(Screen):
    skin = '\n\t<screen position="center,center" size="610,420" title="Aggiorna TM" >\n\t\t<widget name="line1" position="5,5" size="520,30" font="Regular; 26" halign="left" valign="center" transparent="1" />\n\t\t<eLabel backgroundColor="grey" position="2,38" size="610,2" zPosition="3" />\n\t\t<widget name="list" position="5,45" size="600,320" scrollbarMode="showOnDemand" />\n\t\t<ePixmap position="10,372" size="140,40" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/TM-Menu/buttons/red.png" alphatest="on" />\n\t\t<widget position="15,372" size="140,40" name="key_red" font="Regular;20" halign="center" valign="center" zPosition="2" transparent="1" />\n\t\t<ePixmap position="160,372" size="140,40" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/TM-Menu/buttons/green.png" alphatest="on" />\n\t\t<widget position="160,372" size="140,40" name="key_green" font="Regular;20" halign="center" valign="center" zPosition="2" transparent="1" />\n\t\t<ePixmap position="310,372" size="140,40" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/TM-Menu/buttons/yellow.png" alphatest="on" />\n\t\t<widget position="310,372" size="140,40" name="key_yellow" font="Regular;20" halign="center" valign="center" zPosition="2" transparent="1" />\n\t\t<ePixmap position="460,372" size="140,40" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/TM-Menu/buttons/blue.png" alphatest="on" />\n\t\t<widget position="480,372" size="140,40" name="key_blue" font="Regular;20" halign="center" valign="center" zPosition="2" transparent="1" />\n\t</screen>'

    def __init__(self, session, args = None):
        Screen.__init__(self, session)
        self.session = session
        try:
            list = listdir('/etc/cs/iptv')
            list = [ x[:-3] for x in list if x.endswith('.sh') ]
        except:
            list = []

        self['line1'] = Label(_('Premi il tasto verde e Aggiorna:'))
        self['key_red'] = Label(_('Close'))
        self['key_green'] = Label(_('Aggiorna'))
        self['key_yellow'] = Label(_('Utilities'))
        self['key_blue'] = Label(_('Info'))
        self['list'] = MenuList(list)
        self['actions'] = ActionMap(['OkCancelActions',
         'WizardActions',
         'InputActions',
         'ColorActions'], {'ok': self.run,
         'red': self.close,
         'green': self.full,
         'yellow': self.utilities,
         'blue': self.Info,
         'cancel': self.close}, -1)

    def run(self):
        script = self['list'].getCurrent()
        if script is not None:
            self.session.open(Console, script.replace('_', ' '), cmdlist=["/usr/script2/%s.sh" % script])
        return

    def full(self):
        self.session.open(Console, _('Executing ...'), ['%s' % cmd])

    def Info(self):
        self.session.open(MessageBox, _('By TiGer-Team https://TiGerteam.cloud'), MessageBox.TYPE_INFO)

    def utilities(self):
        self.session.open(Utilities)


class Utilities(Screen):
    skin = '\n\t<screen position="center,center" size="610,420" title="TM Utilities" >\n\t\t<widget name="line1" position="5,5" size="520,30" font="Regular; 26" halign="left" valign="center" transparent="1" />\n\t\t<eLabel backgroundColor="grey" position="2,38" size="610,2" zPosition="3" />\n\t\t<widget name="list" position="5,45" size="600,320" scrollbarMode="showOnDemand" />\n\t\t<ePixmap position="10,372" size="140,40" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/TM-Menu/buttons/red.png" alphatest="on" />\n\t\t<widget position="15,372" size="140,40" name="key_red" font="Regular;20" halign="center" valign="center" zPosition="2" transparent="1" />\n\t\t<ePixmap position="160,372" size="140,40" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/TM-Menu/buttons/green.png" alphatest="on" />\n\t\t<widget position="160,372" size="140,40" name="key_green" font="Regular;20" halign="center" valign="center" zPosition="2" transparent="1" />\n\t\t<ePixmap position="310,372" size="140,40" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/TM-Menu/buttons/yellow.png" alphatest="on" />\n\t\t<widget position="310,372" size="140,40" name="key_yellow" font="Regular;20" halign="center" valign="center" zPosition="2" transparent="1" />\n\t\t<ePixmap position="460,372" size="140,40" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/TM-Menu/buttons/blue.png" alphatest="on" />\n\t\t<widget position="480,372" size="140,40" name="key_blue" font="Regular;20" halign="center" valign="center" zPosition="2" transparent="1" />\n\t</screen>'

    def __init__(self, session, args = None):
        Screen.__init__(self, session)
        self.session = session
        try:
            list = listdir('/usr/script2')
            list = [ x[:-3] for x in list if x.endswith('.sh') ]
        except:
            list = []

        self['line1'] = Label(_('Seleziona e Aggiorna:'))
        self['key_red'] = Label(_('Close'))
        self['key_green'] = Label(_('Aggiorna'))
        self['key_yellow'] = Label(_('Home'))
        self['key_blue'] = Label(_('Info'))
        self['list'] = MenuList(list)
        self['actions'] = ActionMap(['OkCancelActions',
         'WizardActions',
         'InputActions',
         'ColorActions'], {'ok': self.run,
         'red': self.close,
         'green': self.run,
         'yellow': self.home,
         'blue': self.Info,
         'cancel': self.close}, -1)

    def run(self):
        script = self['list'].getCurrent()
        if script is not None:
            self.session.open(Console, script.replace('_', ' '), cmdlist=["/usr/script2/%s.sh" % script])
        return

    def Info(self):
        self.session.open(MessageBox, _('By TiGer-Team https://TiGerteam.cloud'), MessageBox.TYPE_INFO)

    def home(self):
        self.session.open(PrivatUpload)


def menu(menuid, **kwargs):
    if menuid == 'mainmenu':
        return [('TM-Menu',
          main,
          'UTILITY TM',
          4)]
    return []


def main(session, **kwargs):
    session.open(PrivatUpload)


def Plugins(**kwargs):
    return [PluginDescriptor(name='TM-Menu', description='IPTV VOD UPDATE', where=PluginDescriptor.WHERE_MENU, fnc=menu), PluginDescriptor(name='TM-Menu', description=_('IPTV VOD UPDATE'), where=PluginDescriptor.WHERE_PLUGINMENU, icon='plugin.png', fnc=main), PluginDescriptor(name='TM-Menu', description='IPTV VOD UPDATE', where=PluginDescriptor.WHERE_EXTENSIONSMENU, fnc=main)]